/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import dan200.computercraft.shared.util.RegistryHelper;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;

public record BasicRecipeSerialiser<T extends Recipe<?>>(MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) implements RecipeSerializer<T>
{
    public BasicRecipeSerialiser(MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) {
        this.codec = codec.flatXmap(this::check, DataResult::success);
        this.streamCodec = streamCodec.map(x -> (Recipe)this.check(x).getOrThrow(), Function.identity());
    }

    private DataResult<T> check(T recipe) {
        if (recipe.getSerializer() == this) {
            return DataResult.success(recipe);
        }
        return DataResult.error(() -> "Expected serialiser to be " + String.valueOf(RegistryHelper.getKeyOrThrow(BuiltInRegistries.RECIPE_SERIALIZER, this)) + ", but was " + String.valueOf(RegistryHelper.getKeyOrThrow(BuiltInRegistries.RECIPE_SERIALIZER, recipe.getSerializer())));
    }
}

